import { prisma } from "@/lib/prisma";
import { requireRole } from "@/lib/requireRole";

export async function GET(_: Request, { params }: { params: { id: string } }) {
  await requireRole(["ADMIN"]);

  const batch = await prisma.settlementBatch.findUnique({
    where: { id: params.id },
    include: { lines: true },
  });
  if (!batch) return new Response("Not found", { status: 404 });

  const headers = ["provider", "direction", "count", "amount_minor", "currency"].join(",");
  const rows = batch.lines
    .map((l) => [l.provider, l.direction, l.count, l.amount.toString(), l.currency].join(","))
    .join("\n");

  const csv = `${headers}\n${rows}\n`;

  return new Response(csv, {
    status: 200,
    headers: {
      "Content-Type": "text/csv; charset=utf-8",
      "Content-Disposition": `attachment; filename=lefa_settlement_${batch.id}.csv`,
    },
  });
}
